class Branch {
  float currX, currY, startGirth, currGirth, currLength, distanceToBranch, growthDir, upTendency;
  boolean isGrowing = true;
  Branch (float startX, float startY, float startG, float startDir){
    currX = startX;
    currY = startY;
    startGirth = startG;
    currGirth = startGirth;
    currLength = 0;
    growthDir = startDir;
    upTendency = currGirth/env.upTendency; //use girth to figure final number...fatter branches tend towards the sun more strongly
    resetDistanceToBranch();
    fill(0);
    ellipse( currX, currY, currGirth*1.1, currGirth*1.1 );
  }
  void grow(){
    //increment length and branch distance properties
    currLength ++;
    distanceToBranch --;

    //figure new x and y coords based on growth direction
    currX += cos(growthDir);
    currY += sin(growthDir);

    currGirth = startGirth - (currLength/env.taperFactor);

    if (currGirth < .25){
      isGrowing = false;
    } 
    else {
      fill(0);
      ellipse( currX, currY, currGirth, currGirth );
    }
    //change the growth direction for the next growth cycle
    growthDir += random(-.2,.22); 
    //tendency to grow up towards the sun
    //higher upTendency number pulls toward sun more strongly
    growthDir += ((PI*1.5) - growthDir)*(upTendency/100);
    //turn around if close to top or bottom of stage
    if (currY > stageHeight - 30){
      growthDir += ((PI*1.5) - growthDir)/2;
    } 
  }
  void resetDistanceToBranch(){
    //--------------------------------
    if (currGirth < 5){
      distanceToBranch = int(random(10,30));
    } 
    else {
      distanceToBranch = int(random(50,75));
    }
    //--------------------------------
  }
}
