class Environment {
  color airColor;
  float rRangeL, rRangeH, gRangeL, gRangeH, bRangeL, bRangeH, mistDensity, taperFactor, upTendency;
  boolean hasLeaves, hasFlowers;
  int leafFrequency, maxGirthForLeaf, flowerFrequency;
  float leafSizeFactor, flowerSizeFactor;
  // ------------------------
  float seasonInterval = floor(daysInCycle/4);
  float half = seasonInterval/2;
  float quarter = seasonInterval/4;
  float eighth = seasonInterval/8;

  Environment(){
    //-----------------------
    taperFactor = 23; //higher number causes branch to taper more slowly
    upTendency = 4.5; //factor to use in determining tendency to grow towards sun...higher number is LESS attraction
    //-----------------------
    //fix up our factors...needed for short cycles
    if (eighth < 1){
      eighth = 1;
    }
    if (quarter < 1){
      quarter = 1;
    }
    if (half < 1){
      half = 1;
    }
    //base initial value on lockSeason
    if (lockSeason.equals("winter") == true){
      mistDensity = 20;
      airColor = color(255,255,255);
      leafFrequency = 200;
      maxGirthForLeaf = 1;
      leafSizeFactor = 4;
      flowerFrequency = 125;
      flowerSizeFactor = 1;
      rRangeL = 0;
      rRangeH = 0;
      gRangeL = 200;
      gRangeH = 240;
      bRangeL = 0;
      bRangeH = 0;
      hasLeaves = false;
      hasFlowers = false;
    } 
    else if (lockSeason.equals("spring") == true){
      mistDensity = 75;
      airColor = color(255,240,240);
      leafFrequency = 10;
      maxGirthForLeaf = 4;
      leafSizeFactor = 4;
      flowerFrequency = 75;
      flowerSizeFactor = 1;
      rRangeL = 0;
      rRangeH = 0;
      gRangeL = 180;
      gRangeH = 240;
      bRangeL = 0;
      bRangeH = 0;
      hasLeaves = false;
      hasFlowers = false;
    } 
    else if (lockSeason.equals("summer") == true){
      mistDensity = 75;
      airColor = color(255,255,220);
      leafFrequency = 5;
      maxGirthForLeaf = 5;
      leafSizeFactor = 4;
      flowerFrequency = 125;
      flowerSizeFactor = 1;
      rRangeL = 25;
      rRangeH = 75;
      gRangeL = 100;
      gRangeH = 230;
      bRangeL = 0;
      bRangeH = 0;
      hasLeaves = true;
      hasFlowers = false;
    } 
    else if (lockSeason.equals("fall") == true){
      mistDensity = 40;
      airColor = color(225,225,225);
      leafFrequency = 30;
      maxGirthForLeaf = 4;
      leafSizeFactor = 4;
      flowerFrequency = 125;
      flowerSizeFactor = 1;
      rRangeL = 235;
      rRangeH = 250;
      gRangeL = 0;
      gRangeH = 230;
      bRangeL = 0;
      bRangeH = 0;
      hasLeaves = true;
      hasFlowers = false;
    } 
    else {
      mistDensity = 75;
      airColor = color(255,255,255);
      leafFrequency = 10;
      maxGirthForLeaf = 4;
      leafSizeFactor = 4;
      flowerFrequency = 125;
      flowerSizeFactor = 1;
      rRangeL = 0;
      rRangeH = 0;
      gRangeL = 200;
      gRangeH = 240;
      bRangeL = 0;
      bRangeH = 0;
      hasLeaves = false;
      hasFlowers = false;
    }

  }
  void updateEnvironment(){
    int theSeason;
    //ok this is going to be a little ugly
    if (currTree < seasonInterval){
      theSeason = 1;
    } else if (currTree < seasonInterval*2){
      theSeason = 2;
    } else if (currTree < seasonInterval*3){
      theSeason = 3;
    } else {
      theSeason = 4;
    }
    if (lockSeason.equals("winter") == true){
      theSeason = 4;
    } else if (lockSeason.equals("spring") == true){
      theSeason = 1;
    } else if (lockSeason.equals("summer") == true){
      theSeason = 2;
    } else if (lockSeason.equals("fall") == true){
      theSeason = 3;
    }

    //println(theSeason);

    switch(theSeason){
    case 1:
      //winter...move towards spring
      mistDensity += (50-mistDensity)/quarter;
      airColor = color(255,240,240);
      leafFrequency += (10-leafFrequency)/quarter;
      maxGirthForLeaf += (3-maxGirthForLeaf)/eighth;
      leafSizeFactor += (3-leafSizeFactor)/eighth;
      flowerFrequency += (65-flowerFrequency)/quarter;
      flowerSizeFactor += (1.4-flowerSizeFactor)/quarter;
      rRangeL = 0;
      rRangeH = 0;
      gRangeL = 160;
      gRangeH = 240;
      bRangeL = 0;
      bRangeH = 0;
      if (leafFrequency < 50){
        hasLeaves = true;
      }
      if (flowerFrequency < 100 && hasLeaves == true){
        hasFlowers = true;
      }
      break;
    case 2:
      //spring...move towards summer
      mistDensity += (100-mistDensity)/quarter;
      airColor = color(255,255,220);
      leafFrequency += (5-leafFrequency)/quarter;
      maxGirthForLeaf += (5-maxGirthForLeaf)/quarter;
      leafSizeFactor += (4-leafSizeFactor)/quarter;
      flowerFrequency += (150-flowerFrequency)/eighth;
      flowerSizeFactor = 1.2;
      rRangeL += (25-rRangeL)/quarter;
      rRangeH += (75-rRangeH)/quarter;
      gRangeL += (100-gRangeL)/quarter;
      gRangeH += (230-gRangeH)/quarter;
      bRangeL = 0;
      bRangeH = 0;
      hasLeaves = true;
      if (flowerFrequency > 100){
        hasFlowers = false;
      }
      break;
    case 3:
      //summer...move towards fall
      mistDensity += (40-mistDensity)/half;
      airColor = color(225,225,225);
      hasLeaves = true;
      hasFlowers = false;
      leafFrequency += (30-leafFrequency)/half;
      maxGirthForLeaf += (4-maxGirthForLeaf)/half;
      leafSizeFactor = 4;
      flowerFrequency = 0;
      flowerSizeFactor = 0;
      rRangeL += (235-rRangeL)/half;
      rRangeH += (250-rRangeH)/quarter;
      gRangeL += (0-gRangeL)/half;
      gRangeH = 230;
      bRangeL = 0;
      bRangeH = 0;
      break;
    case 4:
      //fall...move towards winter
      mistDensity += (20-mistDensity)/quarter;
      airColor = color(255,255,255);
      leafFrequency += (200-leafFrequency)/half;
      maxGirthForLeaf += (1-maxGirthForLeaf)/half;
      leafSizeFactor = 4;
      flowerFrequency = 150;
      flowerSizeFactor = 0;
      rRangeL = 220;
      rRangeH = 250;
      gRangeL += (0-gRangeL)/quarter;
      gRangeH = 230;
      bRangeL = 0;
      bRangeH = 0;
      if (leafFrequency > 150){
        hasLeaves = false;
      }
      hasFlowers = false;
      break;
    }
  }
  color getLeafColor(){
    color leafColor = color(random(rRangeL,rRangeH),random(gRangeL,gRangeH),random(bRangeL,bRangeH));
    return leafColor;
  } 
}
