class Leaf {
  float xOrig, yOrig, leafSize, currSize, baseAngle;
  boolean isGrowing;
  color myColor;
  Leaf ( float xo, float yo, float ls, float ba, boolean isBorder ){
    isGrowing = true;
    xOrig = xo;
    yOrig = yo;
    leafSize = ls;
    baseAngle = ba;
    if (isBorder == false){
      currSize = 1;
      myColor = env.getLeafColor();
    } else {
      currSize = leafSize;
      myColor = color(255);
    }
    drawLeaf();
  }
  void drawLeaf(){
    fill(myColor);
    noStroke();
    beginShape();
    vertex( xOrig, yOrig );

    drawVertex(6,currSize/2.5);
    drawVertex(5.8,currSize/3);

    drawVertex(5.8,currSize/1.4);
    drawVertex(5.55,currSize/1.2);
    drawVertex(5.3,currSize/1.3);

    drawVertex(5.1,currSize/1.6);
    drawVertex(5,currSize/1.2);
    ////// --------
    drawVertex(1.5*PI,currSize);
    ////// --------
    drawVertex(4.4,currSize/1.2);
    drawVertex(4.3,currSize/1.6);

    drawVertex(4.1,currSize/1.3);
    drawVertex(3.75,currSize/1.2);
    drawVertex(3.5,currSize/1.4);

    drawVertex(3.5,currSize/3);
    drawVertex(3.3,currSize/2.5);

    vertex( xOrig, yOrig );
    endShape();
  }
  void grow(){
    if (currSize >= leafSize){
      isGrowing = false;
    } 
    else {
      currSize *= 1.1;
      drawLeaf();
    }
  }
  void drawVertex( float angle, float distance ){
    float x = xOrig + cos(angle+baseAngle)*(distance);
    float y = yOrig + sin(angle+baseAngle)*(distance);
    vertex(x,y);
  }
}
