class Tree {
  boolean hasLeaves = env.hasLeaves;
  boolean hasFlowers = env.hasFlowers;
  int leafFrequency = env.leafFrequency;
  int maxGirthForLeaf = env.maxGirthForLeaf;
  float leafSizeFactor = env.leafSizeFactor;
  int flowerFrequency = env.flowerFrequency;
  float flowerSizeFactor = env.flowerSizeFactor;
  //-------------------------
  int currBranch = 0;
  int currLeaf = 0;
  int totalLeaves = 0;
  int totalFlowers = 0;
  boolean isGrowing = true;

  Branch[] branches = new Branch[1000];
  Leaf[] leaves = new Leaf[1000];
  Flower[] flowers = new Flower[1000];
  Tree ( int x, int y ){
    //instantiate first branch object to act as trunk
    branches[ currBranch ] = new Branch( x, y, int(random(10)+12), PI*1.5 );
  }
  void grow(){
    //grow branches
    boolean branchesGrowing = false;
    for (int i=0; i<=currBranch; i++){
      if (branches[i].isGrowing == true){
        branchesGrowing = true;
        branches[i].grow();
        //check whether it's time for a new branch
        if (branches[i].distanceToBranch <= 0){
          branches[i].resetDistanceToBranch();
          currBranch ++;
          if (currBranch >= branches.length){
            branches = (Branch[]) expand(branches);
          }
          branches[ currBranch ] = new Branch( branches[i].currX, branches[i].currY, branches[i].currGirth, random(2.05*PI) ); 
        }
        //add leaves
        if (branches[i].currGirth < maxGirthForLeaf && branches[i].currLength%leafFrequency == 0 && hasLeaves == true){
          totalLeaves ++;
          if (totalLeaves >= leaves.length){
            leaves = (Leaf[]) expand(leaves);
          }
          leaves[ totalLeaves-1 ] = new Leaf( branches[i].currX, branches[i].currY, (branches[i].currGirth*leafSizeFactor)+3, random(2*PI), false );
        }
        //add flowers
        if (branches[i].currGirth < maxGirthForLeaf && branches[i].currLength%flowerFrequency == 0 && hasFlowers == true && int(random(3)) == 1){
          totalFlowers ++;
          if (totalFlowers >= flowers.length){
            flowers = (Flower[]) expand(flowers);
          }
          flowers[ totalFlowers-1 ] = new Flower( branches[i].currX, branches[i].currY, (branches[i].currGirth*flowerSizeFactor)+2 );
        }
      } 
    }

    //branches are done growing, now grow the leaves
    if (branchesGrowing == false){
      boolean leavesGrowing = false;
      //step through the leaves array 10 at a time
      if (totalLeaves > 0){
        for (int i=0; i<=currLeaf; i++){
          if (leaves[i].isGrowing == true){
            leaves[i].grow();
            leavesGrowing = true;
          }
        }
        currLeaf += 10;
        if (currLeaf >= totalLeaves-1){
          currLeaf = totalLeaves-1;
        }
      }

      //leaves are done growing, now grow the flowers
      boolean flowersGrowing = false;
      if (leavesGrowing == false){
        for (int i=0; i<totalFlowers; i++){
          if (flowers[i].isGrowing == true){
            flowers[i].grow();
            flowersGrowing = true;
          }
        }
      }

      //flowers are done, so stop the tree from growing and wait to plant a new one
      if (leavesGrowing == false && flowersGrowing == false){
        isGrowing = false;
        treeDone();
      }
    }
  }
  void clearArrays(){
    Branch[] branches = new Branch[1];
    Leaf[] leaves = new Leaf[1];
    Flower[] flowers = new Flower[1];
  }
}

