/*
  ah, trees :)
  
  by George Shaw
  Cold Spring, NY
  Summer 2007
  
  made on a Mac
  
 */

int stageWidth = 950;
int stageHeight = 400;
int daysInCycle;
String lockSeason, daysInCycleRaw;

//------------------------

Environment env;
Tree[] trees;
int currTree;
boolean isPaused;
int waitCount;

void setup() {
  daysInCycleRaw = param("daysInCycleParam");
  daysInCycle = Integer.parseInt(daysInCycleRaw);
  lockSeason = param("lockSeasonParam");

//------------------------

  env = new Environment();
  trees = new Tree[daysInCycle];
  currTree = floor(daysInCycle/4);
  isPaused = false;
  waitCount = -1;

//------------------------

  size( stageWidth, stageHeight );
  //background( 240, 243, 255 );
  background( 255 );
  smooth();
  noStroke();

  plantNewTree( true );
  
}

void draw(){
  if (isPaused == false && waitCount == -1){
    trees[currTree].grow();
  } 
  else if (waitCount > -1){
    waitCount ++;
    if (waitCount >= 30){
      waitCount = -1;
      plantNewTree( false );
    } 
    else if (waitCount >= 20){
      fadeScreen( env.airColor, env.mistDensity );
    }
  }
  drawBase();
}

void mousePressed(){
  if (isPaused == false){
    isPaused = true;
  } 
  else {
    isPaused = false;
  }
}

// -----------------------------------------------------------

void drawBase(){
  fill(255);
  rect(0,stageHeight-10,stageWidth, 10);
}

void drawBase_OLD(){
  fill(255);
  rect(0,stageHeight-10,stageWidth, 10);
  //---------- BORDER ------------
  //top 
  new Leaf ( 8, 15, 38, 1.1*PI, true );
  new Leaf ( 3, 35, 25, 1.8*PI, true );
  new Leaf ( 1, 50, 17, .8*PI, true );
  new Leaf ( 3, 65, 12, 1.3*PI, true );
  for (int i=0; i<=1000; i+=200){
    int baseHeight = -10;
    new Leaf ( 8+i, baseHeight, 30, 1.1*PI, true );
    new Leaf ( 15+i, baseHeight-1, 23, 1.5*PI, true );
    new Leaf ( 27+i, baseHeight+2, 30, PI, true );
    new Leaf ( 33+i, baseHeight+5, 18, .5*PI, true );
    new Leaf ( 40+i, baseHeight, 20, 1.5*PI, true );
    new Leaf ( 52+i, baseHeight+5, 40, .5*PI, true );
    new Leaf ( 60+i, baseHeight, 25, 1.3*PI, true );
    new Leaf ( 68+i, baseHeight, 22, 1.9*PI, true );
    new Leaf ( 75+i, baseHeight-10, 30, .3*PI, true );
    new Leaf ( 85+i, baseHeight, 15, 2.3*PI, true );
    new Leaf ( 95+i, baseHeight+3, 26, 1.8*PI, true );
    baseHeight += 10;
    new Leaf ( 108+i, baseHeight-10, 40, 1.1*PI, true );
    new Leaf ( 115+i, baseHeight-1, 33, 1.5*PI, true );
    new Leaf ( 127+i, baseHeight+2, 20, PI, true );
    new Leaf ( 133+i, baseHeight, 48, .5*PI, true );
    new Leaf ( 140+i, baseHeight+5, 25, 1.5*PI, true );
    new Leaf ( 152+i, baseHeight+5, 30, .5*PI, true );
    new Leaf ( 160+i, baseHeight-8, 15, 1.3*PI, true );
    new Leaf ( 168+i, baseHeight, 42, 1.9*PI, true );
    new Leaf ( 175+i, baseHeight-2, 30, .3*PI, true );
    new Leaf ( 185+i, baseHeight, 25, 2.3*PI, true );
    new Leaf ( 195+i, baseHeight-3, 26, 1.8*PI, true );
  }
  new Leaf ( width-10, 15, 38, 1.1*PI, true );
  new Leaf ( width-3, 35, 25, 1.8*PI, true );
  new Leaf ( width-1, 50, 17, .8*PI, true );
  new Leaf ( width-3, 65, 12, 1.3*PI, true );

}

void treeDone(){
  waitCount = 0;
  trees[currTree].clearArrays();
}

void plantNewTree( boolean isFirst ){
  int horz;
  currTree ++;
  if (currTree >= daysInCycle){
    currTree = 0;
  }
  env.updateEnvironment();
  if (isFirst == true){
    horz = stageWidth/2;
  } 
  else {
    horz = int(random(50,stageWidth-50));
  }
  trees[currTree] = new Tree( horz, stageHeight-10 );
}

void fadeScreen( color fc, float d){
  color fadeColor = fc;
  float density = d;
  float r,g,b;
  loadPixels();
  for(int i=0; i<pixels.length; i++){
    if (pixels[i] != fadeColor){
      float r1 = pixels[i] >> 16 & 0xFF;
      float r2 = env.airColor >> 16 & 0xFF;
      float g1 = pixels[i] >> 8 & 0xFF;
      float g2 = env.airColor >> 8 & 0xFF;
      float b1 = pixels[i] & 0xFF;
      float b2 = env.airColor & 0xFF;
      if (r1 < r2){
        r = ceil(r1+((r2 - r1)/density));
      } else {
        r = floor(r1+((r2 - r1)/density));
      }
      if (g1 < g2){
        g = ceil(g1+((g2 - g1)/density));
      } else {
        g = floor(g1+((g2 - g1)/density));
      }
      if (b1 < b2){
        b = ceil(b1+((b2 - b1)/density));
      } else {
        b = floor(b1+((b2 - b1)/density));
      }
      pixels[i] = color(r,g,b);
    }
  }
  updatePixels();
}

//--------------------------------------------------




